% ex3_61.m
% Example 3.6.1
% Fig. 3.6, p. 56
%   
clear
N=60;
r=10;
q=1;
F=1; H=1; G=1;
t=0:1:N;
x=zeros(1,N+1);
v=sqrt(r)*randn(1,N+1);
w=sqrt(q)*randn(1,N+1);
y=zeros(1,N+1);
x(1)=0;
% data generation
for i=1:N
x(:,i+1)= F*x(:,i)+ G*w(:,i);
y(:,i)=H*x(:,i) + v(:,i);
end
y(:,N+1)=H*x(:,N+1) + v(:,N+1);
% kalman filter
xep=zeros(1,N+1);   % prediction x_{t/t-1}
xef=zeros(1,N+1);   % filtering  x_{t/t}
Pep=zeros(1,N+1);   % variance of prediction P_{t/t-1}
Pef=zeros(1,N+1);   % variance of filtering P_{t/t}
Pes=zeros(1,N+1);   % variance of smoothing P_{t/N}
Pep(1,1)=10;        % initial covariance of prediction
xep(1,1)=0;
for i=1:N
Pef(1,i)=r*Pep(1,i)/(H*Pep(1,i)*H' + r); % filtered covariance     
K=Pef(1,i)*H/r;                          % Kalman gain
xef(1,i)=xep(1,i) + K*(y(1,i)-H*xep(1,i));    
Pep(1,i+1)=F*Pef(1,i)*F' + G*q*G';       % covarinace of prediction
xep(1,i+1)=F*xef(1,i);                   % predicted estimate
end
Pef(1,N+1)=r*Pep(1,N+1)/(H*Pep(1,N+1)*H' + r);  
K=Pef(1,N+1)*H'/r;       
xee=xep(1,N+1) + K*(y(1,N+1)-H*xep(1,N+1));
xef(1,N+1)=xee;    
% smoothing
xes=zeros(1,N+1);        % smoothed estimate
xes(1,N+1)=xef(1,N+1);   % bundary value at the terminal point
Pes(1,N+1)=Pef(1,N+1);   % bundary value at the terminal point
for k=N+1:-1:2
Sf = Pef(1,k-1)*F'/Pep(1,k);   % smoother gain
xes(1,k-1)= xef(1,k-1)+Sf*(xes(1,k)-xep(1,k));     % smoothed estimate
Pes(1,k-1)= Pef(1,k-1)+Sf*(Pes(1,k)-Pep(1,k))*Sf'; % smoothed covariance
end    

ef=xef-x;
es=xes-x;
varf=var(ef)  % filtering error 
vars=var(es)  % smoothing error

figure(1)
plot(t,x(1,1:N+1),'r',t,y(1,1:N+1),'g-x',t,xef(1,1:N+1),'b-o','LineWidth',1.4)
xlabel('Number of steps 1')
ylabel('Filtering')
title('Fig. 3.6a')
axis([0,N,-10,10]);
grid
legend('True x_t','Observation y_t',...
    'Filtered estimate x_{t/t}')

figure(2)
plot(t,x(1,1:N+1),'r',t,y(1,1:N+1),'g-x',t,xes(1,1:N+1),'b-o','LineWidth',1.4)
xlabel('Number of steps t')
ylabel('Smoothing')
title('Fig. 3.6b')
axis([0,N,-10,10]);
grid
legend('True x_t','Observation y_t',...
    'Smoothed estimate x_{t/N}')

figure(3)
plot(t,Pef(1,1:N+1),'b',t,Pes(1,1:N+1),'m','LineWidth',1.4)
xlabel('Number of steps t')
title('Fig. 3.6c: Variances of Filtering and Smoothing')
axis([0,N,0,6]);
grid
legend('Filtering P_{t/t}','Smoothing P_{t/N}')
